/*
 * Decompiled with CFR 0.152.
 */
package wile.redstonepen.libmc;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_7225;
import net.minecraft.class_8710;
import net.minecraft.class_9139;
import wile.redstonepen.libmc.Auxiliaries;

public class Networking {
    public static void init() {
        PayloadTypeRegistry.playC2S().register(UnifiedPayload.TYPE, UnifiedPayload.STREAM_CODEC);
        PayloadTypeRegistry.playS2C().register(UnifiedPayload.TYPE, UnifiedPayload.STREAM_CODEC);
        ServerPlayNetworking.registerGlobalReceiver(UnifiedPayload.TYPE, (unifed_payload, context) -> {
            class_3222 player = context.player();
            class_3218 world = player.method_51469();
            if (player == null) {
                return;
            }
            class_2487 payload = unifed_payload.data().nbt();
            player.field_13995.execute(() -> {
                switch (unifed_payload.data().id()) {
                    case "tnc2s": {
                        class_2338 pos = class_2338.method_10092((long)payload.method_10537("pos"));
                        class_2487 nbt = payload.method_10562("nbt");
                        class_2586 te = world.method_8321(pos);
                        if (!(te instanceof IPacketTileNotifyReceiver)) {
                            return;
                        }
                        ((IPacketTileNotifyReceiver)te).onClientPacketReceived((class_1657)player, nbt);
                        break;
                    }
                    case "csc2s": {
                        int container_id = payload.method_10550("cid");
                        class_2487 nbt = payload.method_10562("nbt");
                        class_1703 patt0$temp = player.field_7512;
                        if (!(patt0$temp instanceof INetworkSynchronisableContainer)) {
                            return;
                        }
                        INetworkSynchronisableContainer nsc = (INetworkSynchronisableContainer)patt0$temp;
                        if (player.field_7512.field_7763 != container_id) {
                            return;
                        }
                        nsc.onClientPacketReceived(container_id, (class_1657)player, nbt);
                        break;
                    }
                    case "nnc2s": {
                        String hnd = payload.method_10558("hnd");
                        class_2487 nbt = payload.method_10562("nbt");
                        if (hnd.isEmpty() || !PacketNbtNotifyClientToServer.handlers.containsKey(hnd)) {
                            return;
                        }
                        PacketNbtNotifyClientToServer.handlers.get(hnd).accept((class_1657)player, nbt);
                    }
                }
            });
        });
    }

    private static void sendToClient(class_3222 player, String packet_id, class_2487 payload_nbt) {
        ServerPlayNetworking.send((class_3222)player, (class_8710)new UnifiedPayload(new UnifiedPayload.UnifiedData(packet_id, payload_nbt)));
    }

    private static void sendToClients(class_3218 world, String packet_id, class_2487 payload_nbt) {
        UnifiedPayload payload = new UnifiedPayload(new UnifiedPayload.UnifiedData(packet_id, payload_nbt));
        for (class_3222 player : world.method_18456()) {
            ServerPlayNetworking.send((class_3222)player, (class_8710)payload);
        }
    }

    public record UnifiedPayload(UnifiedData data) implements class_8710
    {
        private static final class_9139<class_2540, UnifiedPayload> STREAM_CODEC = class_8710.method_56484(UnifiedPayload::write, UnifiedPayload::new);
        private static final class_8710.class_9154<UnifiedPayload> TYPE = new class_8710.class_9154(class_2960.method_60655((String)"redstonepen", (String)"unpnbt"));

        private UnifiedPayload(class_2540 buf) {
            this(new UnifiedData(buf.method_19772(), buf.method_10798()));
        }

        public static class_8710.class_9154<UnifiedPayload> getTYPE() {
            return TYPE;
        }

        private void write(class_2540 buf) {
            this.data.write(buf);
        }

        public class_8710.class_9154<UnifiedPayload> method_56479() {
            return TYPE;
        }

        public record UnifiedData(String id, class_2487 nbt) {
            public UnifiedData(class_2540 buf) {
                this(buf.method_19772(), buf.method_10798());
            }

            public void write(class_2540 buf) {
                buf.method_10814(this.id);
                buf.method_10794((class_2520)this.nbt);
            }

            @Override
            public String toString() {
                return this.id + ": " + this.nbt.toString();
            }
        }
    }

    public static interface IPacketTileNotifyReceiver {
        default public void onServerPacketReceived(class_2487 nbt) {
        }

        default public void onClientPacketReceived(class_1657 player, class_2487 nbt) {
        }
    }

    public static interface INetworkSynchronisableContainer {
        public void onServerPacketReceived(int var1, class_2487 var2);

        public void onClientPacketReceived(int var1, class_1657 var2, class_2487 var3);
    }

    public static class PacketNbtNotifyClientToServer {
        protected static final String PACKET_ID = "nnc2s";
        public static final Map<String, BiConsumer<class_1657, class_2487>> handlers = new HashMap<String, BiConsumer<class_1657, class_2487>>();
    }

    public static class OverlayTextMessage {
        protected static final String PACKET_ID = "otms2c";
        protected static BiConsumer<class_2561, Integer> handler_ = null;
        public static final int DISPLAY_TIME_MS = 3000;

        public static void setHandler(BiConsumer<class_2561, Integer> handler) {
            if (handler_ == null) {
                handler_ = handler;
            }
        }

        public static void sendToPlayer(class_3222 player, class_2561 message) {
            OverlayTextMessage.sendToPlayer(player, message, 3000);
        }

        public static void sendToPlayer(class_3222 player, class_2561 message, int delay) {
            if (Auxiliaries.isEmpty(message)) {
                return;
            }
            try {
                class_2487 payload = new class_2487();
                payload.method_10569("delay", delay);
                payload.method_10582("msg", Auxiliaries.serializeTextComponent(message, (class_7225.class_7874)player.method_56673()));
                Networking.sendToClient(player, PACKET_ID, payload);
            }
            catch (Throwable e) {
                Auxiliaries.logger().error("OverlayTextMessage.toBytes() failed: " + String.valueOf(e));
            }
        }
    }

    public static class PacketNbtNotifyServerToClient {
        protected static final String PACKET_ID = "nns2c";
        public static final Map<String, Consumer<class_2487>> handlers = new HashMap<String, Consumer<class_2487>>();

        public static void sendToPlayer(class_1657 player, String handler, class_2487 nbt) {
            if (nbt == null || handler == null || !(player instanceof class_3222)) {
                return;
            }
            class_3222 splayer = (class_3222)player;
            class_2487 msg = new class_2487();
            msg.method_10582("hnd", handler);
            msg.method_10566("nbt", (class_2520)nbt);
            Networking.sendToClient(splayer, PACKET_ID, msg);
        }

        public static void sendToPlayers(class_1937 world, String handler, class_2487 nbt) {
            if (world != null) {
                for (class_1657 player : world.method_18456()) {
                    PacketNbtNotifyServerToClient.sendToPlayer(player, handler, nbt);
                }
            }
        }
    }

    public static class PacketContainerSyncServerToClient {
        protected static final String PACKET_ID = "css2c";

        public static void sendToPlayer(class_3222 player, int windowId, class_2487 nbt) {
            if (nbt == null || player == null) {
                return;
            }
            class_2487 payload = new class_2487();
            payload.method_10569("cid", windowId);
            payload.method_10566("nbt", (class_2520)nbt);
            Networking.sendToClient(player, PACKET_ID, payload);
        }

        public static void sendToPlayer(class_3222 player, class_1703 container, class_2487 nbt) {
            if (container != null) {
                PacketContainerSyncServerToClient.sendToPlayer(player, container.field_7763, nbt);
            }
        }

        public static <C extends class_1703> void sendToListeners(class_1937 world, C container, class_2487 nbt) {
            for (class_1657 player : world.method_18456()) {
                if (player.field_7512.field_7763 != container.field_7763) continue;
                PacketContainerSyncServerToClient.sendToPlayer((class_3222)player, container.field_7763, nbt);
            }
        }
    }

    public static class PacketContainerSyncClientToServer {
        protected static final String PACKET_ID = "csc2s";
    }

    public static class PacketTileNotifyServerToClient {
        protected static final String PACKET_ID = "tns2c";

        public static void sendToPlayer(class_3222 player, class_2586 te, class_2487 nbt) {
            if (te == null || nbt == null) {
                return;
            }
            class_2487 payload = new class_2487();
            payload.method_10544("pos", te.method_11016().method_10063());
            payload.method_10566("nbt", (class_2520)nbt);
            Networking.sendToClient(player, PACKET_ID, payload);
        }

        public static void sendToPlayers(class_2586 te, class_2487 nbt) {
            class_1937 class_19372;
            if (te == null || !((class_19372 = te.method_10997()) instanceof class_3218)) {
                return;
            }
            class_3218 sworld = (class_3218)class_19372;
            class_2487 payload = new class_2487();
            payload.method_10544("pos", te.method_11016().method_10063());
            payload.method_10566("nbt", (class_2520)nbt);
            Networking.sendToClients(sworld, PACKET_ID, payload);
        }
    }

    public static class PacketTileNotifyClientToServer {
        protected static final String PACKET_ID = "tnc2s";
    }
}

